<?php
/**
 * MySQLUser
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 9.1.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * MySQLUser Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MySQLUser implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MySQLUser';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'db_id' => 'string',
        'username' => 'string',
        'access_hosts' => 'string[]',
        'auth_plugin' => '\OpenAPI\Client\Model\MySQLAuthPlugin',
        'grants' => 'object',
        'created_at' => 'string',
        'is_ephemeral' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'db_id' => 'uuid',
        'username' => null,
        'access_hosts' => null,
        'auth_plugin' => null,
        'grants' => null,
        'created_at' => null,
        'is_ephemeral' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
		'db_id' => false,
		'username' => false,
		'access_hosts' => false,
		'auth_plugin' => false,
		'grants' => false,
		'created_at' => false,
		'is_ephemeral' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'db_id' => 'dbId',
        'username' => 'username',
        'access_hosts' => 'accessHosts',
        'auth_plugin' => 'authPlugin',
        'grants' => 'grants',
        'created_at' => 'createdAt',
        'is_ephemeral' => 'isEphemeral'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'db_id' => 'setDbId',
        'username' => 'setUsername',
        'access_hosts' => 'setAccessHosts',
        'auth_plugin' => 'setAuthPlugin',
        'grants' => 'setGrants',
        'created_at' => 'setCreatedAt',
        'is_ephemeral' => 'setIsEphemeral'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'db_id' => 'getDbId',
        'username' => 'getUsername',
        'access_hosts' => 'getAccessHosts',
        'auth_plugin' => 'getAuthPlugin',
        'grants' => 'getGrants',
        'created_at' => 'getCreatedAt',
        'is_ephemeral' => 'getIsEphemeral'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('db_id', $data ?? [], null);
        $this->setIfExists('username', $data ?? [], null);
        $this->setIfExists('access_hosts', $data ?? [], null);
        $this->setIfExists('auth_plugin', $data ?? [], null);
        $this->setIfExists('grants', $data ?? [], null);
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('is_ephemeral', $data ?? [], false);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['username'] === null) {
            $invalidProperties[] = "'username' can't be null";
        }
        if ($this->container['access_hosts'] === null) {
            $invalidProperties[] = "'access_hosts' can't be null";
        }
        if ($this->container['auth_plugin'] === null) {
            $invalidProperties[] = "'auth_plugin' can't be null";
        }
        if ($this->container['grants'] === null) {
            $invalidProperties[] = "'grants' can't be null";
        }
        if ($this->container['created_at'] === null) {
            $invalidProperties[] = "'created_at' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets db_id
     *
     * @return string|null
     */
    public function getDbId()
    {
        return $this->container['db_id'];
    }

    /**
     * Sets db_id
     *
     * @param string|null $db_id db_id
     *
     * @return self
     */
    public function setDbId($db_id)
    {
        if (is_null($db_id)) {
            throw new \InvalidArgumentException('non-nullable db_id cannot be null');
        }
        $this->container['db_id'] = $db_id;

        return $this;
    }

    /**
     * Gets username
     *
     * @return string
     */
    public function getUsername()
    {
        return $this->container['username'];
    }

    /**
     * Sets username
     *
     * @param string $username username
     *
     * @return self
     */
    public function setUsername($username)
    {
        if (is_null($username)) {
            throw new \InvalidArgumentException('non-nullable username cannot be null');
        }
        $this->container['username'] = $username;

        return $this;
    }

    /**
     * Gets access_hosts
     *
     * @return string[]
     */
    public function getAccessHosts()
    {
        return $this->container['access_hosts'];
    }

    /**
     * Sets access_hosts
     *
     * @param string[] $access_hosts access_hosts
     *
     * @return self
     */
    public function setAccessHosts($access_hosts)
    {
        if (is_null($access_hosts)) {
            throw new \InvalidArgumentException('non-nullable access_hosts cannot be null');
        }
        $this->container['access_hosts'] = $access_hosts;

        return $this;
    }

    /**
     * Gets auth_plugin
     *
     * @return \OpenAPI\Client\Model\MySQLAuthPlugin
     */
    public function getAuthPlugin()
    {
        return $this->container['auth_plugin'];
    }

    /**
     * Sets auth_plugin
     *
     * @param \OpenAPI\Client\Model\MySQLAuthPlugin $auth_plugin auth_plugin
     *
     * @return self
     */
    public function setAuthPlugin($auth_plugin)
    {
        if (is_null($auth_plugin)) {
            throw new \InvalidArgumentException('non-nullable auth_plugin cannot be null');
        }
        $this->container['auth_plugin'] = $auth_plugin;

        return $this;
    }

    /**
     * Gets grants
     *
     * @return object
     */
    public function getGrants()
    {
        return $this->container['grants'];
    }

    /**
     * Sets grants
     *
     * @param object $grants Table names mapped to a list of privileges on that table. The wildcard \"*\" means the privileges are granted for all tables.
     *
     * @return self
     */
    public function setGrants($grants)
    {
        if (is_null($grants)) {
            throw new \InvalidArgumentException('non-nullable grants cannot be null');
        }
        $this->container['grants'] = $grants;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string $created_at created_at
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        if (is_null($created_at)) {
            throw new \InvalidArgumentException('non-nullable created_at cannot be null');
        }
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets is_ephemeral
     *
     * @return bool|null
     */
    public function getIsEphemeral()
    {
        return $this->container['is_ephemeral'];
    }

    /**
     * Sets is_ephemeral
     *
     * @param bool|null $is_ephemeral A flag which marks short-lived mysql accounts. If an account is created as ephemeral, it will be deleted few hours after it's been created. Throwaway accounts are useful for phpMyAdmin logins.
     *
     * @return self
     */
    public function setIsEphemeral($is_ephemeral)
    {
        if (is_null($is_ephemeral)) {
            throw new \InvalidArgumentException('non-nullable is_ephemeral cannot be null');
        }
        $this->container['is_ephemeral'] = $is_ephemeral;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


