<?php
/**
 * LetsencryptApi
 * PHP version 7.4
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 9.1.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * LetsencryptApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class LetsencryptApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createWebsiteDomainLetsencryptCerts' => [
            'application/json',
        ],
    ];

/**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createWebsiteDomainLetsencryptCerts
     *
     * Generate and setup letsencrypt ssl certificates for website&#39;s domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $dry_run If not set or &#x60;dry_run&#x3D;true&#x60; it will only verify domain ownership and get dummy certificates. To enable SSL on domain set &#x60;?dry_run&#x3D;false&#x60;. (optional)
     * @param  bool $enable Defaults to &#x60;enable&#x3D;true&#x60; if not set. To only generate and save certificate in db set &#x60;enable&#x3D;false&#x60;. It has no bearing if &#x60;dry_run&#x3D;false&#x60; not set. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainLetsencryptCerts'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createWebsiteDomainLetsencryptCerts($org_id, $website_id, $domain_id, $dry_run = null, $enable = null, string $contentType = self::contentTypes['createWebsiteDomainLetsencryptCerts'][0])
    {
        $this->createWebsiteDomainLetsencryptCertsWithHttpInfo($org_id, $website_id, $domain_id, $dry_run, $enable, $contentType);
    }

    /**
     * Operation createWebsiteDomainLetsencryptCertsWithHttpInfo
     *
     * Generate and setup letsencrypt ssl certificates for website&#39;s domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $dry_run If not set or &#x60;dry_run&#x3D;true&#x60; it will only verify domain ownership and get dummy certificates. To enable SSL on domain set &#x60;?dry_run&#x3D;false&#x60;. (optional)
     * @param  bool $enable Defaults to &#x60;enable&#x3D;true&#x60; if not set. To only generate and save certificate in db set &#x60;enable&#x3D;false&#x60;. It has no bearing if &#x60;dry_run&#x3D;false&#x60; not set. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainLetsencryptCerts'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWebsiteDomainLetsencryptCertsWithHttpInfo($org_id, $website_id, $domain_id, $dry_run = null, $enable = null, string $contentType = self::contentTypes['createWebsiteDomainLetsencryptCerts'][0])
    {
        $request = $this->createWebsiteDomainLetsencryptCertsRequest($org_id, $website_id, $domain_id, $dry_run, $enable, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createWebsiteDomainLetsencryptCertsAsync
     *
     * Generate and setup letsencrypt ssl certificates for website&#39;s domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $dry_run If not set or &#x60;dry_run&#x3D;true&#x60; it will only verify domain ownership and get dummy certificates. To enable SSL on domain set &#x60;?dry_run&#x3D;false&#x60;. (optional)
     * @param  bool $enable Defaults to &#x60;enable&#x3D;true&#x60; if not set. To only generate and save certificate in db set &#x60;enable&#x3D;false&#x60;. It has no bearing if &#x60;dry_run&#x3D;false&#x60; not set. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainLetsencryptCerts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteDomainLetsencryptCertsAsync($org_id, $website_id, $domain_id, $dry_run = null, $enable = null, string $contentType = self::contentTypes['createWebsiteDomainLetsencryptCerts'][0])
    {
        return $this->createWebsiteDomainLetsencryptCertsAsyncWithHttpInfo($org_id, $website_id, $domain_id, $dry_run, $enable, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createWebsiteDomainLetsencryptCertsAsyncWithHttpInfo
     *
     * Generate and setup letsencrypt ssl certificates for website&#39;s domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $dry_run If not set or &#x60;dry_run&#x3D;true&#x60; it will only verify domain ownership and get dummy certificates. To enable SSL on domain set &#x60;?dry_run&#x3D;false&#x60;. (optional)
     * @param  bool $enable Defaults to &#x60;enable&#x3D;true&#x60; if not set. To only generate and save certificate in db set &#x60;enable&#x3D;false&#x60;. It has no bearing if &#x60;dry_run&#x3D;false&#x60; not set. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainLetsencryptCerts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteDomainLetsencryptCertsAsyncWithHttpInfo($org_id, $website_id, $domain_id, $dry_run = null, $enable = null, string $contentType = self::contentTypes['createWebsiteDomainLetsencryptCerts'][0])
    {
        $returnType = '';
        $request = $this->createWebsiteDomainLetsencryptCertsRequest($org_id, $website_id, $domain_id, $dry_run, $enable, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createWebsiteDomainLetsencryptCerts'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $dry_run If not set or &#x60;dry_run&#x3D;true&#x60; it will only verify domain ownership and get dummy certificates. To enable SSL on domain set &#x60;?dry_run&#x3D;false&#x60;. (optional)
     * @param  bool $enable Defaults to &#x60;enable&#x3D;true&#x60; if not set. To only generate and save certificate in db set &#x60;enable&#x3D;false&#x60;. It has no bearing if &#x60;dry_run&#x3D;false&#x60; not set. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainLetsencryptCerts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createWebsiteDomainLetsencryptCertsRequest($org_id, $website_id, $domain_id, $dry_run = null, $enable = null, string $contentType = self::contentTypes['createWebsiteDomainLetsencryptCerts'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createWebsiteDomainLetsencryptCerts'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling createWebsiteDomainLetsencryptCerts'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling createWebsiteDomainLetsencryptCerts'
            );
        }




        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/{domain_id}/letsencrypt';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $dry_run,
            'dryRun', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $enable,
            'enable', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
