<?php
/**
 * ImportersApi
 * PHP version 7.4
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 9.1.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * ImportersApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ImportersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'analyzeImportMigration' => [
            'application/json',
        ],
        'checkImportMigrationResources' => [
            'application/json',
        ],
        'createImportMigration' => [
            'application/json',
        ],
        'deleteImportMigration' => [
            'application/json',
        ],
        'getImportMigration' => [
            'application/json',
        ],
        'getImportMigrationData' => [
            'application/json',
        ],
        'getImportMigrationLog' => [
            'application/json',
        ],
        'getImportMigrations' => [
            'application/json',
        ],
        'uploadImportMigration' => [
            'multipart/form-data',
        ],
    ];

/**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation analyzeImportMigration
     *
     * Analyze imported migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['analyzeImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function analyzeImportMigration($org_id, $import_migration_id, string $contentType = self::contentTypes['analyzeImportMigration'][0])
    {
        $this->analyzeImportMigrationWithHttpInfo($org_id, $import_migration_id, $contentType);
    }

    /**
     * Operation analyzeImportMigrationWithHttpInfo
     *
     * Analyze imported migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['analyzeImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function analyzeImportMigrationWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['analyzeImportMigration'][0])
    {
        $request = $this->analyzeImportMigrationRequest($org_id, $import_migration_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation analyzeImportMigrationAsync
     *
     * Analyze imported migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['analyzeImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function analyzeImportMigrationAsync($org_id, $import_migration_id, string $contentType = self::contentTypes['analyzeImportMigration'][0])
    {
        return $this->analyzeImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation analyzeImportMigrationAsyncWithHttpInfo
     *
     * Analyze imported migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['analyzeImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function analyzeImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['analyzeImportMigration'][0])
    {
        $returnType = '';
        $request = $this->analyzeImportMigrationRequest($org_id, $import_migration_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'analyzeImportMigration'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['analyzeImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function analyzeImportMigrationRequest($org_id, $import_migration_id, string $contentType = self::contentTypes['analyzeImportMigration'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling analyzeImportMigration'
            );
        }

        // verify the required parameter 'import_migration_id' is set
        if ($import_migration_id === null || (is_array($import_migration_id) && count($import_migration_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_id when calling analyzeImportMigration'
            );
        }


        $resourcePath = '/v2/orgs/{org_id}/import/{import_migration_id}/analyze';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_id !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_id' . '}',
                ObjectSerializer::toPathValue($import_migration_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation checkImportMigrationResources
     *
     * Check if all resources from the imported migration could be created.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody $importer_migration_req_body importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkImportMigrationResources'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ResourceCheckError
     */
    public function checkImportMigrationResources($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['checkImportMigrationResources'][0])
    {
        list($response) = $this->checkImportMigrationResourcesWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body, $contentType);
        return $response;
    }

    /**
     * Operation checkImportMigrationResourcesWithHttpInfo
     *
     * Check if all resources from the imported migration could be created.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkImportMigrationResources'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ResourceCheckError, HTTP status code, HTTP response headers (array of strings)
     */
    public function checkImportMigrationResourcesWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['checkImportMigrationResources'][0])
    {
        $request = $this->checkImportMigrationResourcesRequest($org_id, $import_migration_id, $importer_migration_req_body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\ResourceCheckError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\ResourceCheckError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\ResourceCheckError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\ResourceCheckError';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ResourceCheckError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation checkImportMigrationResourcesAsync
     *
     * Check if all resources from the imported migration could be created.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkImportMigrationResources'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkImportMigrationResourcesAsync($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['checkImportMigrationResources'][0])
    {
        return $this->checkImportMigrationResourcesAsyncWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation checkImportMigrationResourcesAsyncWithHttpInfo
     *
     * Check if all resources from the imported migration could be created.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkImportMigrationResources'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkImportMigrationResourcesAsyncWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['checkImportMigrationResources'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ResourceCheckError';
        $request = $this->checkImportMigrationResourcesRequest($org_id, $import_migration_id, $importer_migration_req_body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'checkImportMigrationResources'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkImportMigrationResources'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function checkImportMigrationResourcesRequest($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['checkImportMigrationResources'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling checkImportMigrationResources'
            );
        }

        // verify the required parameter 'import_migration_id' is set
        if ($import_migration_id === null || (is_array($import_migration_id) && count($import_migration_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_id when calling checkImportMigrationResources'
            );
        }



        $resourcePath = '/v2/orgs/{org_id}/import/{import_migration_id}/resource';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_id !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_id' . '}',
                ObjectSerializer::toPathValue($import_migration_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($importer_migration_req_body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($importer_migration_req_body));
            } else {
                $httpBody = $importer_migration_req_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createImportMigration
     *
     * Create a new import migration.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody $importer_migration_req_body importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createImportMigration($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['createImportMigration'][0])
    {
        $this->createImportMigrationWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body, $contentType);
    }

    /**
     * Operation createImportMigrationWithHttpInfo
     *
     * Create a new import migration.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createImportMigrationWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['createImportMigration'][0])
    {
        $request = $this->createImportMigrationRequest($org_id, $import_migration_id, $importer_migration_req_body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createImportMigrationAsync
     *
     * Create a new import migration.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createImportMigrationAsync($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['createImportMigration'][0])
    {
        return $this->createImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createImportMigrationAsyncWithHttpInfo
     *
     * Create a new import migration.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['createImportMigration'][0])
    {
        $returnType = '';
        $request = $this->createImportMigrationRequest($org_id, $import_migration_id, $importer_migration_req_body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createImportMigration'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createImportMigrationRequest($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['createImportMigration'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createImportMigration'
            );
        }

        // verify the required parameter 'import_migration_id' is set
        if ($import_migration_id === null || (is_array($import_migration_id) && count($import_migration_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_id when calling createImportMigration'
            );
        }



        $resourcePath = '/v2/orgs/{org_id}/import/{import_migration_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_id !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_id' . '}',
                ObjectSerializer::toPathValue($import_migration_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($importer_migration_req_body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($importer_migration_req_body));
            } else {
                $httpBody = $importer_migration_req_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteImportMigration
     *
     * Delete single migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteImportMigration($org_id, $import_migration_id, string $contentType = self::contentTypes['deleteImportMigration'][0])
    {
        $this->deleteImportMigrationWithHttpInfo($org_id, $import_migration_id, $contentType);
    }

    /**
     * Operation deleteImportMigrationWithHttpInfo
     *
     * Delete single migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteImportMigrationWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['deleteImportMigration'][0])
    {
        $request = $this->deleteImportMigrationRequest($org_id, $import_migration_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteImportMigrationAsync
     *
     * Delete single migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteImportMigrationAsync($org_id, $import_migration_id, string $contentType = self::contentTypes['deleteImportMigration'][0])
    {
        return $this->deleteImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteImportMigrationAsyncWithHttpInfo
     *
     * Delete single migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['deleteImportMigration'][0])
    {
        $returnType = '';
        $request = $this->deleteImportMigrationRequest($org_id, $import_migration_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteImportMigration'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteImportMigrationRequest($org_id, $import_migration_id, string $contentType = self::contentTypes['deleteImportMigration'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteImportMigration'
            );
        }

        // verify the required parameter 'import_migration_id' is set
        if ($import_migration_id === null || (is_array($import_migration_id) && count($import_migration_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_id when calling deleteImportMigration'
            );
        }


        $resourcePath = '/v2/orgs/{org_id}/import/{import_migration_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_id !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_id' . '}',
                ObjectSerializer::toPathValue($import_migration_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getImportMigration
     *
     * Fetches single migration details
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ImportMigrationEntry
     */
    public function getImportMigration($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigration'][0])
    {
        list($response) = $this->getImportMigrationWithHttpInfo($org_id, $import_migration_id, $contentType);
        return $response;
    }

    /**
     * Operation getImportMigrationWithHttpInfo
     *
     * Fetches single migration details
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ImportMigrationEntry, HTTP status code, HTTP response headers (array of strings)
     */
    public function getImportMigrationWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigration'][0])
    {
        $request = $this->getImportMigrationRequest($org_id, $import_migration_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\ImportMigrationEntry' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\ImportMigrationEntry' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\ImportMigrationEntry', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\ImportMigrationEntry';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ImportMigrationEntry',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getImportMigrationAsync
     *
     * Fetches single migration details
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationAsync($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigration'][0])
    {
        return $this->getImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getImportMigrationAsyncWithHttpInfo
     *
     * Fetches single migration details
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigration'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ImportMigrationEntry';
        $request = $this->getImportMigrationRequest($org_id, $import_migration_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getImportMigration'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getImportMigrationRequest($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigration'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getImportMigration'
            );
        }

        // verify the required parameter 'import_migration_id' is set
        if ($import_migration_id === null || (is_array($import_migration_id) && count($import_migration_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_id when calling getImportMigration'
            );
        }


        $resourcePath = '/v2/orgs/{org_id}/import/{import_migration_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_id !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_id' . '}',
                ObjectSerializer::toPathValue($import_migration_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getImportMigrationData
     *
     * Get import migration information
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationData'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ImporterAnalyzedData
     */
    public function getImportMigrationData($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationData'][0])
    {
        list($response) = $this->getImportMigrationDataWithHttpInfo($org_id, $import_migration_id, $contentType);
        return $response;
    }

    /**
     * Operation getImportMigrationDataWithHttpInfo
     *
     * Get import migration information
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationData'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ImporterAnalyzedData, HTTP status code, HTTP response headers (array of strings)
     */
    public function getImportMigrationDataWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationData'][0])
    {
        $request = $this->getImportMigrationDataRequest($org_id, $import_migration_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\ImporterAnalyzedData' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\ImporterAnalyzedData' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\ImporterAnalyzedData', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\ImporterAnalyzedData';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ImporterAnalyzedData',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getImportMigrationDataAsync
     *
     * Get import migration information
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationData'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationDataAsync($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationData'][0])
    {
        return $this->getImportMigrationDataAsyncWithHttpInfo($org_id, $import_migration_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getImportMigrationDataAsyncWithHttpInfo
     *
     * Get import migration information
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationData'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationDataAsyncWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationData'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ImporterAnalyzedData';
        $request = $this->getImportMigrationDataRequest($org_id, $import_migration_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getImportMigrationData'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationData'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getImportMigrationDataRequest($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationData'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getImportMigrationData'
            );
        }

        // verify the required parameter 'import_migration_id' is set
        if ($import_migration_id === null || (is_array($import_migration_id) && count($import_migration_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_id when calling getImportMigrationData'
            );
        }


        $resourcePath = '/v2/orgs/{org_id}/import/{import_migration_id}/analyze';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_id !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_id' . '}',
                ObjectSerializer::toPathValue($import_migration_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getImportMigrationLog
     *
     * Get the log for an import migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationLog'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ImportMigrationLogEntry[]
     */
    public function getImportMigrationLog($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationLog'][0])
    {
        list($response) = $this->getImportMigrationLogWithHttpInfo($org_id, $import_migration_id, $contentType);
        return $response;
    }

    /**
     * Operation getImportMigrationLogWithHttpInfo
     *
     * Get the log for an import migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationLog'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ImportMigrationLogEntry[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getImportMigrationLogWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationLog'][0])
    {
        $request = $this->getImportMigrationLogRequest($org_id, $import_migration_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\ImportMigrationLogEntry[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\ImportMigrationLogEntry[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\ImportMigrationLogEntry[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\ImportMigrationLogEntry[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ImportMigrationLogEntry[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getImportMigrationLogAsync
     *
     * Get the log for an import migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationLog'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationLogAsync($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationLog'][0])
    {
        return $this->getImportMigrationLogAsyncWithHttpInfo($org_id, $import_migration_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getImportMigrationLogAsyncWithHttpInfo
     *
     * Get the log for an import migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationLog'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationLogAsyncWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationLog'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ImportMigrationLogEntry[]';
        $request = $this->getImportMigrationLogRequest($org_id, $import_migration_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getImportMigrationLog'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationLog'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getImportMigrationLogRequest($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationLog'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getImportMigrationLog'
            );
        }

        // verify the required parameter 'import_migration_id' is set
        if ($import_migration_id === null || (is_array($import_migration_id) && count($import_migration_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_id when calling getImportMigrationLog'
            );
        }


        $resourcePath = '/v2/orgs/{org_id}/import/{import_migration_id}/log';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_id !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_id' . '}',
                ObjectSerializer::toPathValue($import_migration_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getImportMigrations
     *
     * List all import migrations
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrations'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ImportMigrationFullListing
     */
    public function getImportMigrations($org_id, string $contentType = self::contentTypes['getImportMigrations'][0])
    {
        list($response) = $this->getImportMigrationsWithHttpInfo($org_id, $contentType);
        return $response;
    }

    /**
     * Operation getImportMigrationsWithHttpInfo
     *
     * List all import migrations
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrations'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ImportMigrationFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getImportMigrationsWithHttpInfo($org_id, string $contentType = self::contentTypes['getImportMigrations'][0])
    {
        $request = $this->getImportMigrationsRequest($org_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\ImportMigrationFullListing' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\ImportMigrationFullListing' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\ImportMigrationFullListing', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\ImportMigrationFullListing';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ImportMigrationFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getImportMigrationsAsync
     *
     * List all import migrations
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationsAsync($org_id, string $contentType = self::contentTypes['getImportMigrations'][0])
    {
        return $this->getImportMigrationsAsyncWithHttpInfo($org_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getImportMigrationsAsyncWithHttpInfo
     *
     * List all import migrations
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationsAsyncWithHttpInfo($org_id, string $contentType = self::contentTypes['getImportMigrations'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ImportMigrationFullListing';
        $request = $this->getImportMigrationsRequest($org_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getImportMigrations'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getImportMigrationsRequest($org_id, string $contentType = self::contentTypes['getImportMigrations'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getImportMigrations'
            );
        }


        $resourcePath = '/v2/orgs/{org_id}/import';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadImportMigration
     *
     * Upload file for analyzing and processing.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_kind The type of migration file being uploaded. (required)
     * @param  \SplFileObject $backup backup (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewResourceUuid
     */
    public function uploadImportMigration($org_id, $import_migration_kind, $backup = null, string $contentType = self::contentTypes['uploadImportMigration'][0])
    {
        list($response) = $this->uploadImportMigrationWithHttpInfo($org_id, $import_migration_kind, $backup, $contentType);
        return $response;
    }

    /**
     * Operation uploadImportMigrationWithHttpInfo
     *
     * Upload file for analyzing and processing.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_kind The type of migration file being uploaded. (required)
     * @param  \SplFileObject $backup (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewResourceUuid, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadImportMigrationWithHttpInfo($org_id, $import_migration_kind, $backup = null, string $contentType = self::contentTypes['uploadImportMigration'][0])
    {
        $request = $this->uploadImportMigrationRequest($org_id, $import_migration_kind, $backup, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\OpenAPI\Client\Model\NewResourceUuid' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\NewResourceUuid' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\NewResourceUuid', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation uploadImportMigrationAsync
     *
     * Upload file for analyzing and processing.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_kind The type of migration file being uploaded. (required)
     * @param  \SplFileObject $backup (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadImportMigrationAsync($org_id, $import_migration_kind, $backup = null, string $contentType = self::contentTypes['uploadImportMigration'][0])
    {
        return $this->uploadImportMigrationAsyncWithHttpInfo($org_id, $import_migration_kind, $backup, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadImportMigrationAsyncWithHttpInfo
     *
     * Upload file for analyzing and processing.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_kind The type of migration file being uploaded. (required)
     * @param  \SplFileObject $backup (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadImportMigrationAsyncWithHttpInfo($org_id, $import_migration_kind, $backup = null, string $contentType = self::contentTypes['uploadImportMigration'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
        $request = $this->uploadImportMigrationRequest($org_id, $import_migration_kind, $backup, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadImportMigration'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_kind The type of migration file being uploaded. (required)
     * @param  \SplFileObject $backup (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadImportMigrationRequest($org_id, $import_migration_kind, $backup = null, string $contentType = self::contentTypes['uploadImportMigration'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling uploadImportMigration'
            );
        }

        // verify the required parameter 'import_migration_kind' is set
        if ($import_migration_kind === null || (is_array($import_migration_kind) && count($import_migration_kind) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_kind when calling uploadImportMigration'
            );
        }



        $resourcePath = '/v2/orgs/{org_id}/import/upload/{import_migration_kind}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_kind !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_kind' . '}',
                ObjectSerializer::toPathValue($import_migration_kind),
                $resourcePath
            );
        }

        // form params
        if ($backup !== null) {
            $multipart = true;
            $formParams['backup'] = [];
            $paramFiles = is_array($backup) ? $backup : [$backup];
            foreach ($paramFiles as $paramFile) {
                $formParams['backup'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
